<?php

return array(

    /*
    |--------------------------------------------------------------------------
    | Cipher used for API transactions
    |--------------------------------------------------------------------------
    |
    | Supported ciphers are: 'AES-128-CBC' and 'AES-256-CBC'
    |
    */

    'cipher' => null,

    /*
    |--------------------------------------------------------------------------
    | Current API version
    |--------------------------------------------------------------------------
    |
    | Set version to be used in API transactions
    |
    */

    'current_version' => env('API_CURRENT_VERSION'),

    /*
    |--------------------------------------------------------------------------
    | Use different database schema for transaction tables
    |--------------------------------------------------------------------------
    |
    | If null, use default schema for your application. If specified, use
    | specified schema for all temporary tables
    |
    */

    'transaction_schema' => env('API_TRANSACTION_SCHEMA'),
    
    /*
    |--------------------------------------------------------------------------
    | Debug abnormal transactions (do not invalidate)
    |--------------------------------------------------------------------------
    |
    | If the value is eavaluated as true, the transaction will not be
    | automatically invalidated should any exception thrown
    |
    */

    'transaction_enable_debug_abnormal' => env('API_TRANSACTION_DEBUG'),

    /*
    |--------------------------------------------------------------------------
    | Use encryption when transacting data
    |--------------------------------------------------------------------------
    |
    | If the value is eavaluated as true, the transaction will use encryption
    | of data and expect the data recieved to be encrypted
    | (except for auth request)
    |
    */

    'transaction_use_encryption' => !env('API_DEBUG_NO_REAL_ENCRYPTION'),

    /*
    |--------------------------------------------------------------------------
    | Versions namespace and path
    |--------------------------------------------------------------------------
    |
    | Namespace and path of project-specific version files
    |
    */

    'versions_namespace' => 'App\\Api',
    'versions_path' => implode([app()->path(), DIRECTORY_SEPARATOR, 'Api']),

    /*
    |--------------------------------------------------------------------------
    | Session lifetime
    |--------------------------------------------------------------------------
    |
    | Amount of minutes in which the Transaction becomes outdated
    |
    */

    'session_lifetime' => 120,
    
    /*
    |--------------------------------------------------------------------------
    | Buffer size
    |--------------------------------------------------------------------------
    |
    | Amount of records of some class to be buffered for bulk insert
    | before flushing the buffer from memory into base
    |
    */

    'buffer_size' => 1000,
    
    /*
    |--------------------------------------------------------------------------
    | Api key holder class
    |--------------------------------------------------------------------------
    |
    | Class which holds api keys info
    | Should provide:
    |
    |    public static function findByKey(string $key): ApiKeyInterface;
    |
    */

    'api_keys_class' => null,
    
    /*
    |--------------------------------------------------------------------------
    | Use internal Exception handler
    |--------------------------------------------------------------------------
    |
    | Use a handler provided by the ApiCore package instead of default one
    |
    */

    'exception_debug' => false,
    
    /*
    |--------------------------------------------------------------------------
    | Cache data prefix
    |--------------------------------------------------------------------------
    |
    | Use prefix for cacheable data in cache storage
    |
    */

    'cache_prefix' => null,
    
    /*
    |--------------------------------------------------------------------------
    | Trace log path
    |--------------------------------------------------------------------------
    |
    | If null, trace log is not performed
    |
    */

    'trace_log_path' => env('API_TRACE_LOG_PATH'),
    
    /*
    |--------------------------------------------------------------------------
    | Dispatch Eloquent events globally
    | This will make significant performance drop, but will allow to see them
    | in debugbar
    |--------------------------------------------------------------------------
    */

    'event_dispatch' => env('ELOQUENT_EVENT_GLOBAL_DISPATCH', false),
    
    /*
    |--------------------------------------------------------------------------
    | Use attributes cache between requests
    |--------------------------------------------------------------------------
    |
    | Significantly improves performance of batch operations with models
    | Not recommended in development because it wound't react
    | to recent changes in model structure without clearing the cache
    |
    */

    'attibutes_cache' => env('API_ATTRIBUTE_CACHE_ON'),
    
    /*
    |--------------------------------------------------------------------------
    | Prefix for ApiCore routes (if registered via Boostrapper)
    |--------------------------------------------------------------------------
    |
    | Use prefix for routes of the transactor
    |
    */

    'route_prefix' => env('API_ROUTES_SUBFOLDER'),
    
    /*
    |--------------------------------------------------------------------------
    | Allow all Api2Api requests through unsafe HTTP connection
    |--------------------------------------------------------------------------
    |
    | Must be strictly equal to true, otherwise disabled. Only use for debug in development!
    |
    */

    'api_2_api_allow_unsafe_http' => env('API_API2API_ALLOW_UNSAFE_HTTP'),

);
