# ApiCore package

A library to construct API's using Transactor and abstact context- and database-independent Data Transfer Objects 

#### Requirements:
- Apache
- PHP >= 8.0
- MariaDB server
- Laravel (>= 8.0), or Lumen (>= 8.0) installation
- Composer

### Installation
1. Request access to repository https://github.com/InfusemediaTeam/api
2. Add repository to your project's composer.json (before other repositories that may contain other versions of api-infusemedia):

```
"repositories": [ { "type": "vcs", "url": "git@github.com:InfusemediaTeam/api.git" } ],
```

3. Add into require section:

```
"infusemedia-team/api": "dev-master"
```

4. Ensure your composer can access the repository. If you use .ssh, ensure you have a key in ~/.ssh and use `composer install -n`

5. Edit .env, for all options, check config/api_core.php in this repository

6. Make sure your Laravel/Lumen installation have a proper `APP_KEY` in .env, if not, generate it as `str_random(32)` and update in the .env

7. If you install in Lumen, make sure you have enabled Facades and Eloquent in `bootstrap/app.php`:

```
$app->withFacades();

$app->withEloquent();
```

Then add ApiCore Bootstrapper to `bootstrap/app.php`:

```
/*
|--------------------------------------------------------------------------
| Register ApiCore
|--------------------------------------------------------------------------
*/
$apiCore = new InSegment\ApiCore\Bootstrap\Bootstrapper($app, __DIR__);
```

To add middlewares:

```
$apiCore->withMiddlewares();
```

To add sessions:

```
$apiCore->withSession();
```

To add routes:

```
$apiCore->withRoutes();
```

Finally:

```
$apiCore->bootstrap();
```

8. Create folder App\Api with the following structure:
```
app/Api
app/Api/V_1_0/DTODefs.php
app/Api/V_1_0/rules.json
app/Api/V_1_0/uuidables.json
```

9. If you need to change api-infusemedia config file, copy config/api_core.php from this repository into your project and edit it
10. In DTODefs extend DTOUtil and implement all abstract methods
11. Write rules in rules.json for all classes you want to use; [How to Write Rules](src/Api/V_1_0/rules.md)
12. Add Transactible trait and TransactibleModel interface to all Eloquent Models used in transactions
13. Write slice transfers; [How to Write Slice Transfers](readme_slice_transfer.md)
