<?php

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

//LV-CM API ROUTES \\

//AUTHORIZATION
$app->group(['middleware' => ['api.key:api_key,route,session']], function() use ($app) {
    $app->post('auth', 'LumenApiController@authorizeApiKey');
});

//ACTIONS
$app->group(['middleware' => ['api.key:api_key,route,session', 'api.version:v']], function () use ($app) {
    // SLICE EXCHANGE STRUCTURE
    $app->post('get-slice-structure', 'LumenApiController@getTablesSliceStructure');
});

//ACTIONS
$app->group(['middleware' => ['api.key:api_key,session', 'api.version:v']], function() use ($app) {
    //TRANSACTION
    $app->post('transaction/acquire', 'LumenApiController@acquireTransaction');
    $app->post('transaction/status', 'LumenApiController@showTransactionStatus');
    $app->post('transaction/close', 'LumenApiController@closeTransaction');
    $app->post('transaction/undo', 'LumenApiController@undoTransaction');

    //GETTERS
    $app->post('export/{type}', 'LumenApiController@export');

    //SETTERS
    $app->post('set/{type}', 'LumenApiController@set');
    $app->post('update/{type}', 'LumenApiController@update');
});