<?php

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

//LV-CM API ROUTES \\

//AUTHORIZATION
Route::post('auth', 'ApiController@authorizeApiKey')->middleware('api.key:api_key,route,session');

//ACTIONS
Route::group(['middleware' => ['api.key:api_key,route,session', 'api.version:v']], function () {
    // SLICE EXCHANGE STRUCTURE
    Route::post('get-slice-structure', 'ApiController@getTablesSliceStructure');
});

Route::group(['middleware' => ['api.key:api_key,session', 'api.version:v']], function () {
    
    //TRANSACTION
    Route::post('transaction/acquire', 'ApiController@acquireTransaction');
    Route::post('transaction/status', 'ApiController@showTransactionStatus');
    Route::post('transaction/close', 'ApiController@closeTransaction');
    Route::post('transaction/undo', 'ApiController@undoTransaction');

    //GETTERS
    Route::post('export/{type}', 'ApiController@export');

    //SETTERS
    Route::post('set/{type}', 'ApiController@set');
    Route::post('update/{type}', 'ApiController@update');
});
