<?php

namespace InSegment\ApiCore\MappingTypes;

use Illuminate\Support\Arr;
use InSegment\ApiCore\Api\TransferEngine;

class Method extends MappingType
{
    /**
     * Should return an array of strings representing types of mappings
     * which are to be handled by this class
     * 
     * @return array
     */
    public static function coversTypes(): array
    {
        return ['method'];
    }

    /**
     * Constructor
     * 
     * @param \InSegment\ApiCore\Api\TransferEngine $engine
     */
    public function __construct(TransferEngine $engine)
    {
        /**
         * @var \InSegment\ApiCore\Api\TransferEngine $this
         */
        parent::__construct(
            $engine,
                
            /**
             * Import function
             * 
             * @var \InSegment\ApiCore\Api\TransferEngine $this
             */
            function ($mapping) {
                $mappingToField = Arr::get($mapping, 'field');
                $mappingToMethod = $mapping['methodTo'];
                $context = &$this->context;
                
                if (isset($mappingToField)) {
                    if ($this->update || !isset($this->model->$mappingToField)) {
                        $this->model->$mappingToField = is_string($mappingToMethod)
                            ? $this->model->$mappingToMethod($this->input, $context)
                            : $mappingToMethod($this->model, $this->input, $context);
                    }
                } else if (is_string($mappingToMethod)) {
                    $this->model->$mappingToMethod($this->input, $context, $this->update);
                } else {
                    $mappingToMethod($this->model, $this->input, $context, $this->update);
                }
            },
                    
            /**
             * Export function
             * 
             * @var \InSegment\ApiCore\Api\TransferEngine $this
             */
            function ($mapping) {
                $field = Arr::get($mapping, 'field');
                $method = $mapping['methodFrom'];
                if (isset($field)) {
                    $this->input = is_string($method)
                        ? ([$this->model, $method])($this->model->$field)
                        : $method($this->model, $this->model->$field);
                } else if (is_string($method)) {
                    $this->input = ([$this->model, $method])();
                } else {
                    $this->input = $method($this->model);
                }
            }
        );
    }

}
