<?php

namespace InSegment\ApiCore\Api\V_2_0;

class CustomRuleSet
{
    /**
     * Rule set
     * 
     * @var array
     */
    public $rules;
    
    /**
     * Name of custom rule set
     *
     * @var string 
     */
    protected $name;
    
    /**
     * Constructor
     * 
     * @param array $rules
     * @param string|null $name
     */
    public function __construct(array $rules = [], string $name = null)
    {
        $this->rules = $rules;
        if (isset($name)) {
            $this->name = "custom_{$name}";
        } else {
            $this->name = 'custom_' . bin2hex(random_bytes(10));
        }
    }
    
    /**
     * Get the custom ruleset name
     * 
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    
    /**
     * Set rules for class $class
     * 
     * @param array $rules
     * @param string|null $class
     * @return $this
     */
    public function setRules(array $rules, string $class = null)
    {
        if (isset($class)) {
            $this->rules[$class] = $rules;
        } else {
            $this->rules = $rules;
        }
        
        return $this;
    }
    
    /**
     * Merge rules with existing
     * 
     * @param array $rules
     * @param string|null $class
     * @return $this
     */
    public function mergeRules(array $rules, string $class = null)
    {
        if (isset($class)) {
            foreach ($rules as $key => $value) {
                if (!isset($this->rules[$class][$key])) {
                    $this->rules[$class][$key] = $value;
                }
            }
        } else {
            foreach ($rules as $class => $rule) {
                foreach ($rule as $key => $value) {
                    if (!isset($this->rules[$class][$key])) {
                        $this->rules[$class][$key] = $value;
                    }
                }
            }
        }
        
        return $this;
    }
    
}
