<?php

namespace InSegment\ApiCore\Api\V_2_0;

use Illuminate\Database\Eloquent\Model;

class DTODictionary
{
    /**
     * The key used to build dictionary
     *
     * @var array|string|null
     */
    protected $key;
    
    /**
     * Keys by input keys / keys from the only entry
     *
     * @var array
     */
    protected $keys;
    
    /**
     * Index by nested key parts to the input key
     *
     * @var array
     */
    protected $index;
    
    /**
     * Is multiple
     *
     * @var bool
     */
    protected $multiple;
    
    /**
     * Constructor
     * 
     * @param \InSegment\ApiCore\Api\V_2_0\DTOUtil $dtoDefs
     * @param string $class
     * @param mixed $input
     */
    public function __construct($dtoDefs, string $class, $key, $input, array $options)
    {
        $this->key = $key;
        $this->multiple = $options['multiple'];
        
        list($this->keys, $this->index) = $dtoDefs->getExtKeyInfo($class, $key, $input, [
            'multiple' => $options['multiple'],
            'index' => true,
            'check' => $options['check'] ?? false
        ]);
    }
    
    /**
     * Get input key for the result by external keys of result
     * 
     * @param \Illuminate\Database\Eloquent\Model $result
     * @return string|int|null
     */
    public function getInputKeyForResult(Model $result)
    {
        if (!isset($this->key)) {
            return null;
        }
        
        if (is_array($this->key)) {
            $indexLookup = $this->index;
            foreach ($this->key as $attributeOfClass) {
                $valueFromResult = $result->getAttribute($attributeOfClass);
                $indexLookup = $indexLookup[$valueFromResult] ?? null;
                
                if (!isset($indexLookup)) {
                    break;
                }
            }
            
            return $indexLookup;
        } else {
            $valueFromResult = $result->getAttribute($this->key);
            return $this->index[$valueFromResult] ?? null;
        }
    }
}
