<?php

namespace InSegment\ApiCore\Api\V_2_0\MappingTypes;

use InSegment\ApiCore\Models\TraverseState;
use InSegment\ApiCore\Interfaces\DTOCharacteristics;

class Method extends MappingType
{
    /**
     * Should return an array of strings representing types of mappings
     * which are to be handled by this class
     * 
     * @return array
     */
    public static function coversTypes(): array
    {
        return ['method'];
    }

    /**
     * Import
     * 
     * @param \InSegment\ApiCore\Models\TraverseState $state
     */
    public function import(TraverseState $state)
    {
        $field = $state->mapping['field'] ?? null;
        $isUpdate = $state->mode === DTOCharacteristics::MODE_UPDATE;
        $mappingToMethod = $state->mapping['methodTo'];

        if (isset($field)) {
            if ($isUpdate || $state->model->getAttribute($field) === null) {
                $state->model->setAttribute($field, is_string($mappingToMethod)
                    ? $state->model->$mappingToMethod($state->data, $isUpdate)
                    : $mappingToMethod($state->model, $state->data, $isUpdate)
                );
            }
        } else if (is_string($mappingToMethod)) {
            $state->model->$mappingToMethod($state->data, $isUpdate);
        } else {
            $mappingToMethod($state->model, $state->data, $isUpdate);
        }
    }

    /**
     * Export
     * 
     * @param \InSegment\ApiCore\Models\TraverseState $state
     */
    public function export(TraverseState $state)
    {
        $field = $state->mapping['field'] ?? null;
        $method = $state->mapping['methodFrom'];
        
        if (isset($field)) {
            $state->data = is_string($method)
                ? $state->model->$method($state->model->getAttribute($field))
                : $method($state->model, $state->model->getAttribute($field));
        } else if (is_string($method)) {
            $state->data = $state->model->$method();
        } else {
            $state->data = $method($state->model);
        }
    }

    /**
     * Configure rule mapping
     * 
     * @param string $class
     * @param array $mapping
     * @return array
     */
    public static function configureRuleMapping($class, $mapping): array
    {
        return $mapping;
    }

}
