<?php

namespace InSegment\ApiCore\Console\Commands;

use InSegment\ApiCore\Middleware\ChooseVersion;
use InSegment\ApiCore\Facades\DTODefs;

use Illuminate\Console\Command;

class EnumerateApiJsonRelations extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'api:enumerateJsonRelations '
                         . '{rootClass : Qualified class name of the Model from which to enumerate relations}'
                         . '{--v= : Specify API version to use enumeration for, current by default}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Enumerates relation types of JSON conversion for API';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $rootClass = $this->argument('rootClass');
        $version = $this->option('v') ?: ChooseVersion::getCurrentVersion();
        
        ChooseVersion::chooseVersion($version);
        $out = DTODefs::performInspection($rootClass, 'relations');
        foreach ($out as $dot => $class) {
            $this->info("{$dot} => {$class}");
        }
        
    }
}
