<?php

namespace InSegment\ApiCore\Console\Commands;

use Illuminate\Console\Command;
use InSegment\ApiCore\Middleware\ChooseVersion;
use InSegment\ApiCore\Services\Transactor;

class EnumerateApiJsonUniques extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'api:enumerateJsonUniques '
                         . '{rootClass : Qualified class name of the Model from which to enumerate relations}'
                         . '{--v= : Specify API version to use enumeration for, current by default}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Enumerates primary and unique keys used by tables in JSON conversion for API';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $rootClass = $this->argument('rootClass');
        $version = $this->option('v') ?: ChooseVersion::getCurrentVersion();
        
        ChooseVersion::chooseVersion($version);
        
        foreach (Transactor::getColumnUniqueData($rootClass) as $table => $data) {
            foreach ($data as &$fields) {
                $fields = '(' . implode(', ', $fields) . ')';
            }
            
            $data = implode(', ', $data);
            $this->info("{$table}: [{$data}]");
        }
    }
}
