<?php

namespace InSegment\ApiCore\Console\Commands;

use Illuminate\Support\Str;
use Illuminate\Console\Command;
use Illuminate\Support\Composer;
use Illuminate\Filesystem\Filesystem;

class TransactionTableCommand extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'transaction:table';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create migrations for the transaction database tables';

    /**
     * The filesystem instance.
     *
     * @var \Illuminate\Filesystem\Filesystem
     */
    protected $files;

    /**
     * @var \Illuminate\Support\Composer
     */
    protected $composer;

    /**
     * Create a new session table command instance.
     *
     * @param  \Illuminate\Filesystem\Filesystem  $files
     * @param  \Illuminate\Support\Composer  $composer
     * @return void
     */
    public function __construct(Filesystem $files, Composer $composer)
    {
        parent::__construct();

        $this->files = $files;
        $this->composer = $composer;
    }

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        if (!class_exists(Str::studly('create_transactions_table'))) {
            $this->files->put($this->createBaseMigration('create_transactions_table'), $this->files->get(__DIR__.'/stubs/transactions.stub'));
        }
        
        if (!class_exists(Str::studly('create_transaction_counts_table'))) {
            $this->files->put($this->createBaseMigration('create_transaction_counts_table'), $this->files->get(__DIR__.'/stubs/transaction_counts.stub'));
        }

        $this->info('Migrations created successfully!');

        $this->composer->dumpAutoloads();
    }

    /**
     * Create a base migration file for the session.
     *
     * @param $name
     * @return string
     */
    protected function createBaseMigration($name)
    {
        $path = $this->laravel->databasePath().'/migrations';

        return $this->laravel['migration.creator']->create($name, $path);
    }
}
