<?php

namespace InSegment\ApiCore\Exceptions;

class ApiRequestException extends ApiTransactorException
{

    const CODE_WRONG_RESPONSE = 20001;
    const CODE_FAILED_REQUEST = 20002;
    const CODE_MESSAGES = [
        self::CODE_WRONG_RESPONSE => 'Response was inadequate.',
        self::CODE_FAILED_REQUEST => 'Failed request.',
    ];

    public function compile(...$args)
    {
        self::normalizeArgs($args);

        if (isset(self::CODE_MESSAGES[$this->code])) {
            $this->message = self::CODE_MESSAGES[$this->code];
        } else {
            parent::compile(...$args);
        }

        return $this;
    }

}
