<?php

namespace InSegment\ApiCore\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;

use Exception;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that should not be reported.
     *
     * @var array
     */
    protected $dontReport = HandlerConstants::DONT_REPORT_DEFAULTS;
    
    use BaseHandling {
        report as report7x;
        render as render7x;
        renderForConsole as renderForConsole7x;
    };
    
    public function report(Exception $exception) {
        $this->report7x($exception);
    }
    
    public function render($request, Exception $exception) {
        return $this->render7x($request, $exception);
    }
    
    public function renderForConsole($output, Exception $e) {
        $this->renderForConsole7x($output, $e);
    }
}
