<?php

namespace InSegment\ApiCore\Inspections;

/**
 * Special auto-count inspection that uses logic for fields with destination
 */
class DestinatedCountInspection extends AutoCountInspection
{
    /**
     * Get count amount to auto set
     * This override counts only by different related field (part of destination before '/')
     * 
     * @return int
     */
    protected function getAutoAmount()
    {
        $relatedField = explode('/', $this->currentMapping['destination'])[0];
        
        if (!isset($this->inspectData['dynUW'][$this->currentTable])) {
            $this->inspectData['dynUW'][$this->currentTable] = true;
        }
        
        if (!empty($this->inspectData['destinated'][$this->parentTable][$relatedField])) {
            return 0;
        }
        
        $this->inspectData['destinated'][$this->parentTable][$relatedField][] = true;
        return $this->countOutput[$this->parentTable];
    }
}
