<?php

namespace InSegment\ApiCore\Interfaces;

interface SliceManagementInterface
{
    /**
     * Get slice operation UID
     * 
     * @return string
     */
    public function getUID(): string;
    
    /**
     * Get schema name for transaction tables
     * 
     * @return string
     */
    public function getSchema(): string;
    
    /**
     * Get count of records was written for table
     * 
     * @param string $table
     * @return int
     */
    public function getWrittenCount(string $table): int;
    
    /**
     * Get count of records was inserted into table
     * 
     * @param string $table
     * @return int
     */
    public function getNewCount(string $table): int;
    
}
