<?php

namespace InSegment\ApiCore\Interfaces;

use InSegment\ApiCore\Api\StaticRuleAnalysis;

/**
 * Complex rule inspection which don't fit into plain Closure
 */
interface StaticRuleInspection
{
    /**
     * StaticRuleInspection must have information about StaticRuleAnalysis instance
     * Probably you would just __construct StaticRuleInspection with StaticRuleAnalysis and implement a getter
     * 
     * @return \InSegment\ApiCore\Api\StaticRuleAnalysis
     */
    public function getAnalyser(): StaticRuleAnalysis;

    /**
     * Main inspection method
     * Accepts information from analyser, returns confirmation to proceed further with this inspection
     * 
     * @param string $dotFormat
     * @param array $mapping
     * @param string $handlerClass
     * @param string $relatedClass
     * @return bool
     */
    public function inspectRule($dotFormat, &$mapping, $handlerClass, $relatedClass): bool;
}
