<?php

namespace InSegment\ApiCore\Interfaces;

interface TransactibleModel
{
    /**
     * Appoint Model transaction
     * 
     * @return $this
     */
    public function appointTransactionWrite();
    
    /**
     * Receive Model in transaction stating that it is actually written
     * 
     * @param bool $wasDirty
     * @param bool $dontSave
     * @return $this
     */
    public function performTransactionReceive(bool $wasDirty, bool $dontSave);
    
    /**
     * Do actions needed on import, return the Model for import or anything evaluating to false to skip
     * 
     * @param mixed $input
     * @param mixed $context
     * @param bool $isUpdate
     * @return \InSegment\ApiCore\Interfaces\TransactibleModel
     */
    public function newFromImport(&$input, &$context, $isUpdate);
}
