<?php

namespace InSegment\ApiCore\Models;

use Illuminate\Database\Eloquent\Model;
use InSegment\ApiCore\Traits\EventsReplace;
use InSegment\ApiCore\Traits\CachesAttributes;

abstract class BaseOperation extends Model
{
    use EventsReplace;
    use CachesAttributes;
    
    const STATUS_ACTIVE = 'active';
    const STATUS_STALE = 'stale';
    const STATUS_ABORT = 'abort';
    const STATUS_DONE = 'done';
    
    const CLEAN_STATUS_DIRTY = '';
    const CLEAN_STATUS_CLEAN = 'clean';
    
    const STATUSES = [self::STATUS_ACTIVE, self::STATUS_ABORT, self::STATUS_DONE, self::STATUS_STALE];
    const CLEAN_STATUSES = [self::CLEAN_STATUS_DIRTY, self::CLEAN_STATUS_CLEAN];
    
    /**
     * Fillable attributes
     * 
     * @var array
     */
    protected $fillable = [
        'uid',
        'status',
        'clean_status'
    ];
    
    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'uid';
    
    /**
     * Indicate the uid is not incrementing
     * 
     * @var bool 
     */
    public $incrementing = false;

    /**
     * The model has timestamps
     * 
     * @var bool
     */
    public $timestamps = true;
    
    /**
     * Select outdated BaseOperations
     * 
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeOutdated($query)
    {
        $lifetimeMinutes = (int) config('api_core.session_lifetime', config('session.lifetime'));
        
        return $query->whereRaw("`updated_at` < UTC_TIMESTAMP() - INTERVAL {$lifetimeMinutes} MINUTE");
    }
}
