<?php

namespace InSegment\ApiCore\Models;

class DeletedTransactionRecord extends SupplementarySliceTable
{
    /**
     * Fillable attributes
     * 
     * @var array
     */
    protected $fillable = [
        'table',
        'key_name',
        'key'
    ];
    
    /**
     * Run the migrations.
     *
     * @param array $options [
     *     'tablesToKeys' => [
     *          string $table => string $key,
     *          ...
     *     ],
     *     'uid' => string|null,
     *     'inMemory' => bool|null,
     *     'temporary' => bool|null
     * ]
     * @return string|null
     */
    public static function establish(array $options)
    {
        $tablesEnum = "'" . implode("', '", array_keys($options['tablesToKeys'])) . "'";
        $keyNamesEnum = "'" . implode("', '", array_unique(array_values($options['tablesToKeys']))) . "'";
        
        return static::createSupplementary($options, [
            "`table` ENUM ({$tablesEnum}) NOT NULL",
            "`key_name` ENUM ({$keyNamesEnum}) NOT NULL",
            "`key` VARCHAR(255) NOT NULL",
            "PRIMARY KEY `deleted_transaction_records_primary` (`table`, `key_name`, `key`)"
        ]);
        
//        Schema::create((new static([], $uid))->getTable(), function (Blueprint $table) use ($enabledTablesToKeys, $inMemory) {
//            if ($inMemory) {
//                $table->engine = 'MEMORY';
//            }
//            
//            $table->enum('table', array_keys($enabledTablesToKeys));
//            $table->enum('key_name', array_unique(array_values($enabledTablesToKeys)));
//            $table->string('key');
//            $table->index(['table'], 'deleted_transaction_records_table_index');
//            $table->primary(['table', 'key_name', 'key'], 'deleted_transaction_records_primary');
//        });
    }
}
