<?php

namespace InSegment\ApiCore\Models;

class SADSource
{
    /**
     * Parameters
     *
     * @var array
     */
    public $params;
    
    /**
     * Content (collection)
     *
     * @var array
     */
    public $arrayItems;
    
    /**
     * Current index of the content in collection
     *
     * @var int
     */
    public $intIndex = 0;
    
    /**
     * Current index of attribute
     *
     * @var int
     */
    public $attrIndex = 0;
    
    /**
     * Total items in collection
     *
     * @var int
     */
    public $total;
    
    /**
     * Current processing state
     *
     * @var int
     */
    public $state = SourceAttributeDownstream::ACCEPT_STATE_INITIAL;
    
    /**
     * Attributes set
     *
     * @var \InSegment\ApiCore\Models\SADAttribute
     */
    public $attribute;
    
    public function __construct(SADAttribute $attribute, array $arrayItems = [], array $params = [])
    {
        $this->params = $params;
        $this->arrayItems = $arrayItems;
        $this->total = count($arrayItems);
        $this->attribute = $attribute;
    }
}
