<?php

namespace InSegment\ApiCore\Models;

use InSegment\ApiCore\Interfaces\AutoKeyRemapInterface;

class SliceRemap extends SupplementarySliceTable implements AutoKeyRemapInterface
{
    protected $primaryKey = 'substitution_uuid';
    protected $autoKeyField = 'destination_id';
    
    /**
     * Run the migrations.
     *
     * @param array $options [
     *     'tables' => string[],
     *     'uid' => string|null,
     *     'inMemory' => bool|null,
     *     'temporary' => bool|null
     * ]
     * @return string|null
     */
    public static function establish(array $options)
    {
        $tablesEnum = "'" . implode("', '", $options['tables']) . "'";
        
        return static::createSupplementary($options, [
            "`substitution_uuid` BIGINT(20) UNSIGNED NOT NULL",
            "`original_id` INT(10) UNSIGNED DEFAULT NULL",
            "`destination_id` INT(10) UNSIGNED DEFAULT NULL",
            "`query_id` INT(10) UNSIGNED NOT NULL",
            "`table` ENUM ({$tablesEnum}) NOT NULL",
            "PRIMARY KEY `slice_remap_primary` (`substitution_uuid`)",
            "UNIQUE KEY `slice_remap_table_unique` (`table`, `original_id`)",
            "KEY `slice_remap_original_id_index` (`original_id`)",
            "KEY `slice_remap_destination_id_index` (`destination_id`)",
            "KEY `slice_remap_lookup_original_id_index` (`table`, `query_id`, `original_id`)"
        ]);
    }

    /**
     * Name of the auto-key field in remap
     * 
     * @return string
     */
    public function autoKeyFieldName(): string
    {
        return $this->autoKeyField;
    }

    /**
     * Name of the UUID field in remap
     * 
     * @return string
     */
    public function uuidFieldName(): string
    {
        return $this->primaryKey;
    }

    /**
     * Dispose rows which was not used to remap something
     * 
     * @return null
     */
    public function disposeUnused()
    {
        // nothing to do
    }

}
