<?php

namespace InSegment\ApiCore\Models;

use Illuminate\Support\Facades\DB;

class TableOfRows extends SupplementaryTable
{
  
    /**
     * Whether it is known that the table exists
     *
     * @var bool
     */
    protected static $tableExists;
    
    /**
     * Last-known count the table have
     *
     * @var int|null
     */
    protected static $knownHaveCount = null;
    
    /**
     * Database schema
     * 
     * @var string
     */
    protected static $databaseSchema;
    
    /**
     * Constructor
     * 
     * @param array $attributes
     * @param string|null $uid
     */
    public function __construct(array $attributes = array())
    {
        parent::__construct($attributes);
        
        $database = static::$databaseSchema ?? (static::$databaseSchema = config('api_core.transaction_schema') ?: DB::getDatabaseName());
        $this->table = "{$database}.{$this->getTable()}";
    }
    
    /**
     * Run the migrations.
     *
     * @param array $options [
     *     'count' => int
     * ]
     * @return null
     */
    public static function establish(array $options)
    {
        if (static::$tableExists === null) {
            static::$tableExists = static::existsSupplementary();
        }
        
        if (!static::$tableExists) {
            static::createSupplementary(['inMemory' => true], ["`zero` BINARY(0) NOT NULL DEFAULT ''"]);
            static::$tableExists = true;
            static::$knownHaveCount = 0;
        }
        
        $haveCount = static::$knownHaveCount;
        $needCount = $options['count'];
        
        if ($needCount && $needCount > ($haveCount ?? 0)) {
            list($schema, $table) = explode('.', (new static)->getTable());
            
            if ($haveCount === null) {
                $haveCount = static::count();
            }
            
            if (!$haveCount) {
                DB::statement("INSERT INTO `{$schema}`.`{$table}` () VALUES ()");
                $haveCount = 1;
            }
            
            while ($haveCount < $needCount) {
                $haveCount += DB::affectingStatement(
                    "INSERT INTO `{$schema}`.`{$table}` () SELECT * FROM `{$schema}`.`{$table}` LIMIT ?",
                    [$needCount - $haveCount]
                );
            }
            
            static::$knownHaveCount = $haveCount;
        }
    }
    
    /**
     * Query with count rows
     * 
     * @param int $count
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public static function take($count)
    {
        static::establish(['count' => $count]);
        return static::query()->take($count);
    }

}
