<?php

namespace InSegment\ApiCore\Models;

use Illuminate\Database\Query\Builder;
use Illuminate\Support\Facades\DB;

class UUIDDeletion extends SupplementarySliceTable
{
    protected $primaryKey = 'uuid';
    
    /**
     * Run the migrations.
     *
     * @param array $options [
     *     'uid' => string|null,
     *     'inMemory' => bool|null,
     *     'temporary' => bool|null
     * ]
     * @return string|null
     */
    public static function establish(array $options)
    {
        $options['temporary'] = true;
        
        return static::createSupplementary($options, [
            "`uuid` BIGINT(20) UNSIGNED NOT NULL",
            "PRIMARY KEY `uuid_deletion_primary` (`uuid`)",
        ]);
    }
    
    /**
     * Drop temporary table
     *
     * @param string|null $uid
     * @return null
     */
    public static function disband($uid = null)
    {
        $myTable = (new static([], $uid))->getTable();
        list($database, $tableName) = explode('.', $myTable);
        DB::statement("DROP TEMPORARY TABLE `{$database}`.`{$tableName}`");
    }
    
    /**
     * @param \Illuminate\Database\Query\Builder $query
     * @param string $uuidSelect
     * @param string $table
     * @return int
     */
    public function insertFromQuery(Builder $query, string $uuidSelect): int
    {
        $myTable = $this->getTable();
        list($database, $tableName) = explode('.', $myTable);
        $queryCopy = (clone $query)->select([$uuidSelect]);
        return DB::affectingStatement(
            "INSERT INTO `{$database}`.`{$tableName}` (`uuid`) {$queryCopy->toSql()}",
            $queryCopy->getBindings()
        );
    }
    
    /**
     * This is necessary to avoid errors about 'cannot reopen table'
     * 
     * @param \Illuminate\Database\Query\Builder $query
     * @param string $uuidSelect
     * @return int
     */
    public function insertThroghTemp(Builder $query, string $uuidSelect): int
    {
        static $postfix = 'a';
        $myTable = $this->getTable();
        list($database, $tableName) = explode('.', $myTable);
        $postfixedTableName = $tableName . '_' . $postfix;
        static::establish(['postfix' => '_' . $postfix++]);
        
        $queryCopy = (clone $query)->select([$uuidSelect]);
        $affected = DB::affectingStatement(
            "INSERT INTO `{$database}`.`{$postfixedTableName}` (`uuid`) {$queryCopy->toSql()}",
            $queryCopy->getBindings()
        );
            
        DB::affectingStatement(
            "INSERT IGNORE INTO `{$database}`.`{$tableName}` (`uuid`) "
            . "SELECT `uuid` FROM `{$database}`.`{$postfixedTableName}`",
            $queryCopy->getBindings()
        );
        
        DB::statement("DROP TEMPORARY TABLE `{$database}`.`{$postfixedTableName}`");
        return $affected;
    }

    /**
     * Name of the UUID field in remap
     * 
     * @return string
     */
    public function uuidFieldName(): string
    {
        return $this->primaryKey;
    }

    /**
     * Dispose rows which was not used to remap something
     * 
     * @return null
     */
    public function disposeUnused()
    {
        // nothing to do there
    }
    
}
