<?php

namespace InSegment\ApiCore\Models;

use InSegment\ApiCore\Exceptions\ApiTransactorException;

class UUIDReserve
{
    /**
     * Operation UID
     *
     * @var string|null
     */
    protected $operationUid;
    
    /**
     * Reserved UUIDs by table
     * 
     * @var array 
     */
    protected $uuidReserve = [];
    
    /**
     * Constructor
     * 
     * @param string|null $operaitonUid
     */
    public function __construct($operaitonUid = null)
    {
        $this->operationUid = $operaitonUid;
    }
    
    /**
     * Allocate amount of UUIDs for table
     * 
     * @param string $table
     * @param type $amount
     */
    public function allocate(string $table, $amount)
    {
        UUIDGeneration::generateForTable($table, $amount, $this->operationUid);
    }
    
    /**
     * This method gives a primary key for a new model
     * 
     * @param string $table
     */
    public function nextId(string $table) {
        if (!isset($this->uuidReserve[$table])) {
            $generationModel = new UUIDGeneration([], $this->operationUid);
            $this->uuidReserve[$table] = $generationModel
                ->newQuery()
                ->where('table', '=', $table)
                ->where('used', '=', false)
                ->orderBy('uuid', 'desc')
                ->pluck('uuid')
                ->toArray();
        }

        $uuid = array_pop($this->uuidReserve[$table]);
        if (!isset($uuid)) {
            throw (new ApiTransactorException(ApiTransactorException::CODE_WRONG_WEIGHT))
                ->compile('Excessive objects supplied')->setData(['table' => $table, 'uuids_num' => count($this->uuidReserve[$table])]);
        }

        return $uuid;
    }
    
}
