<?php

namespace InSegment\ApiCore\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Str;

use InSegment\ApiCore\Console\Commands\TransactionTableCommand;
use InSegment\ApiCore\Console\Commands\SliceOperationsTableCommand;
use InSegment\ApiCore\Console\Commands\EnumerateApiJsonUniques;
use InSegment\ApiCore\Console\Commands\EnumerateApiJsonRelations;
use InSegment\ApiCore\Console\Commands\GarbageCollectTransactions;

class ApiCoreServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        $configPath = __DIR__ . '/../../config/api_core.php';
        if (function_exists('config_path')) {
            $publishPath = config_path('api_core.php');
        } else {
            $publishPath = base_path('config/api_core.php');
        }
        $this->publishes([$configPath => $publishPath], 'config');
        $this->registerMiddleware('InSegment\ApiCore\Middleware\TerminationEvent');
    }
    
    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $configPath = __DIR__ . '/../../config/api_core.php';
        $this->mergeConfigFrom($configPath, 'api_core');

        $this->app->singleton('command.api.transactionTable', TransactionTableCommand::class);
        $this->app->singleton('command.api.sliceOperationsTable', SliceOperationsTableCommand::class);
        $this->app->singleton('command.api.enumerateJsonUniques', EnumerateApiJsonUniques::class);
        $this->app->singleton('command.api.enumerateJsonRelations', EnumerateApiJsonRelations::class);
        $this->app->singleton('command.api.garbageCollectTransactions', GarbageCollectTransactions::class);
        
        $this->commands([
            'command.api.transactionTable',
            'command.api.sliceOperationsTable',
            'command.api.enumerateJsonUniques',
            'command.api.enumerateJsonRelations',
            'command.api.garbageCollectTransactions'
        ]);
    }
    
    /**
     * Register the Debugbar Middleware
     *
     * @param  string $middleware
     */
    protected function registerMiddleware($middleware)
    {
        if (Str::contains($this->app->version(), 'Lumen')) {
            // lumen logic
            $this->app->middleware([$middleware]);
        } else if (($kernel = $this->app['Illuminate\Contracts\Http\Kernel'])) {
            $kernel->pushMiddleware($middleware);
        }
    }

    
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [
            'command.api.enumerateJsonUniques',
            'command.api.enumerateJsonRelations',
            'command.api.garbageCollectTransactions'
        ];
    }
}
