<?php

namespace InSegment\ApiCore\Providers;

use Illuminate\Support\Facades\DB;

use InSegment\ApiCore\Services\JoinResolver;
use InSegment\ApiCore\Services\Transactor;

use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\MorphToMany;
use Illuminate\Database\Eloquent\Relations\HasOneOrMany;
use Illuminate\Database\Eloquent\Relations\MorphOne;

/**
 * InverseOf for relations Yii2-like
 * 
 * Only use to-one relations as an argument
 * 
 * WARNING: This is unfinished. No overuse!
 * DANGER! Avoid recursion. Do not turn on for every request!
 */
class EloquentSerivceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        $app = $this->app;
        
        Collection::macro('extendToAmount', function (int $amount, Model $template) {
            for ($toMake = $amount - count($this); $toMake > 0; --$toMake) {
                $this->push(clone $template);
            }
            
            return $this;
        });
        
        Builder::macro('manyOrNewAmount', function (int $amount, array $attributes, array $values = []) {
            return $this->where($attributes)->take($amount)->get()
                ->extendToAmount($amount, $this->newModelInstance($attributes + $values));
        });
        
        Builder::macro('takeOrNewAmount', function (int $amount, array $attributes = [], array $values = []) {
            return $this->take($amount)->get()
                ->extendToAmount($amount, $this->newModelInstance($attributes + $values));
        });
        
        /**
         * Add relation constraints (the relation must only have simple ones) to attributes of the model
         * and returns new attributes
         * 
         * @param \Illuminate\Database\Eloquent\Relations\Relation $this
         * @param \Illuminate\Database\Eloquent\Model $model
         * @param string|null $table
         * @return array
         */
        Relation::macro('constraintsToAttributes', function ($model, string $table = null) {
            $baseQuery = $this->getBaseQuery();
            
            if (isset($table)) {
                $baseTable = $table;
            } else {
                $class = get_class($model);
                $baseTable = (new $class)->getTable();
            }
            
            $attributes = $model->getAttributes();
            foreach($baseQuery->wheres as $where) {
                if ($where['boolean'] == 'and' && isset($where['column'])) {
                    $exp = explode('.', $where['column']);
                    if (count($exp) > 1) {
                        list($table, $column) = $exp;
                        if ($table != $baseTable) {
                            continue;
                        }
                    } else {
                        $column = $exp[0];
                    }

                    if ($where['type'] == 'Basic' && ($where['operator'] == '=' || $where['operator'] == '!=')) {
                        $current = $attributes[$column] ?? null;
                        if (isset($current) && ($where['operator'] == '=' ^ $current == $where['value'])) {
                            throw new \Exception("Contradiction between relation constrain column ($column) {$where['operator']}"
                                . " value ({$where['value']}) and given Model data ({$current})");
                        } else if ($where['operator'] == '=') {
                            $attributes[$column] = $where['value'];
                        }
                    } else if ($where['type'] == 'Null') {
                        if (isset($attributes[$column])) {
                            throw new \Exception("Contradiction between relation null-value constraint column"
                                . " ({$column}) and given Model data ({$attributes[$column]})");
                        }

                        $attributes[$column] = null;
                    } else if ($where['type'] == 'NotNull') {
                        if (array_key_exists($column, $attributes) && !isset($attributes[$column])) {
                            throw new \Exception("Contradiction between relation not-null-value constraint column"
                                . " ({$column}) and non-given Model data");
                        }
                    } else {
                        throw new \Exception('Incompatible type of additional relation constraint');
                    }
                } else {
                    throw new \Exception('Incompatible boolean of additional relation constraint');
                }
            }

            return $attributes;
        });
        
        /**
         * Get join keys from relation
         * 
         * @param \Illuminate\Database\Eloquent\Relations\Relation $this
         * @param \Illuminate\Database\Eloquent\Model $parent
         * @return array
         */
        Relation::macro('relationJoinKeys', function ($parent) {
            $twoKeys = false;
            static $useOldMethod = null;
            
            if ($this instanceof HasOne) {
                $left = $this->getQualifiedParentKeyName();
                $right = $this->getQualifiedForeignKeyName();
                
                if ($this instanceof MorphOne) {
                    $morphType = $this->getMorphType();
                    $morphClass = addslashes($this->getMorphClass());
                    $left2 = $morphType;
                    $right2 = DB::raw("'{$morphClass}'");
                    $twoKeys = true;
                }
            } else if ($this instanceof BelongsTo) {
                // Compatibility with Lumen 5.4
                if ($useOldMethod === null) {
                    $useOldMethod = \method_exists($this, 'getQualifiedForeignKey');
                }
                $left = $useOldMethod ? $this->getQualifiedForeignKey() : $this->getQualifiedForeignKeyName();
                if ($this instanceof MorphTo) {
                    $right = $parent->getTable() . '.' . $parent->getKeyName();
                    
                    $morphType = explode('.', $left[0])[0] . '.' . $this->getMorphType();
                    $morphClass = addslashes($parent->getMorphClass());
                    $left2 = $morphType;
                    $right2 = DB::raw("'{$morphClass}'");
                    $twoKeys = true;
                } else {
                    $right = $this->getQualifiedOwnerKeyName();
                }
            } else {
                throw new \Exception("Unsupported (yet) relation type for inverse");
            }
            
            if ($twoKeys) {
                return [
                    ['left' => $left, 'right' => $right],
                    [
                        'left' => $left2,
                        // TODO: for correct for on Laravel 10 and more
                        'right' => is_string($right2)
                            ? $right2
                            : $right2->getValue(DB::connection()->getQueryGrammar()),
                    ],
                ];
            }
            
            return [['left' => $left, 'right' => $right]];
        });
        
        /**
         * Set an information about inverse of relation for concrete relation
         * 
         * @param \Illuminate\Database\Eloquent\Relations\Relation $this
         * @param string $relationName
         * @return \Illuminate\Database\Eloquent\Relations\Relation
         */
        Relation::macro('inverseOf', function ($relationName) {
            JoinResolver::resolve($this, $relationName);
            return $this;
        });
        
        /**
         * Ability to check a protected property on Relation
         */
        Relation::macro('isConstraintsEnabled', function () {
            return static::$constraints;
        });
        
        /**
         * Relation::noConstraints counter-measure
         * 
         * @param \Closure $callback
         * @return mixed
         */
        Relation::macro('yesConstraints', function (\Closure $callback) {
            $previous = static::$constraints;

            static::$constraints = true;

            // Laravel implementation of Relation::noConstraints has a limitation
            // it can only be applied globally, and any subsequent relation-creating calls inside
            // are done without constraints, this method allows to temporarily re-enable them
            try {
                return call_user_func($callback);
            } finally {
                static::$constraints = $previous;
            }
        });
    }
    
    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
