<?php

namespace InSegment\ApiCore\Services\Api2Api;

use InSegment\ApiCore\Services\Logger;

/**
 * Recommended implementation: adapter to GuzzleHttp\Client
 */
interface CommunicationClientInterface
{
    /**
     * Communicate with destination using method, uri and options
     * 
     * @param string $method
     * @param string $uri
     * @param array $options
     * @throws \InSegment\ApiCore\Exceptions\ApiRequestException
     */
    public function request($method, $uri, array $options = []);
    
    /**
     * 
     * @param \InSegment\ApiCore\Services\Logger $logger
     * @param \Throwable $e
     * @param string $logTag
     */
    public function logExceptionDetails(Logger $logger, \Throwable $e, string $logTag);
}
