<?php

namespace InSegment\ApiCore\Services\Api2Api;

interface ConnectorInterface
{
    /**
     * Set use cookies
     * 
     * @param bool $use
     * @return $this
     */
    public function setUseCookies(bool $use = true);
    
    /**
     * Set default headers
     * 
     * @param array $headers
     * @return $this
     */
    public function setDefaultHeaders(array $headers);
    
    /**
     * Get instance of CommunicationClientInterface
     * 
     * @return \InSegment\ApiCore\Services\Api2Api\CommunicationClientInterface
     */
    public function getClient(): CommunicationClientInterface;
}
