<?php

namespace InSegment\ApiCore\Services\Api2Api;

use GuzzleHttp\Client;
use InSegment\ApiCore\Services\Logger;

class GuzzleCommunicationClient implements CommunicationClientInterface
{
    
    /**
     * @var GuzzleHttp\Client
     */
    protected $guzzleClient;

    /**
     * Constructor
     * 
     * @param \InSegment\ApiCore\Services\Api2Api\GuzzleConnector $connector
     */
    public function __construct(GuzzleConnector $connector)
    {
        $this->guzzleClient = new Client($connector->getGuzzleOptionsArray());
    }

    /**
     * @inheritDoc
     */
    public function logExceptionDetails(Logger $logger, \Throwable $exception, string $logTag)
    {
        if ($exception instanceof \GuzzleHttp\Exception\RequestException) {
            $response = $exception->getResponse();
            $contents = $response ? $response->getBody(true) : null;
            if ($contents instanceof \Psr\Http\Message\StreamInterface) {
                $contents = $contents->getContents();
            }

            $errorData = json_decode($contents, true);

            if (json_last_error() === JSON_ERROR_NONE) {
                $logger->push("{$logTag} > Error Data", $errorData);
                $logger->push("{$logTag} > Error Exception", [
                    'class' => get_class($exception),
                    'code' => $exception->getCode(),
                    'message' => $exception->getMessage(),
                ]);
            } else {
                $logger->push("{$logTag} > Error Contents", $contents);
            }
        } else {
            $logger->push("{$logTag} > Error Exception", [
                'class' => get_class($exception),
                'code' => $exception->getCode(),
                'message' => $exception->getMessage(),
            ]);
        }
        
        $logger->close();
    }

    /**
     * @inheritDoc
     */
    public function request($method, $uri, array $options = [])
    {
        return $this->guzzleClient->request($method, $uri, $options);
    }

}
