<?php

namespace InSegment\ApiCore\Services\Api2Api;

class GuzzleConnector implements ConnectorInterface
{
    /**
     * Default headers for each request
     *
     * @var array
     */
    protected $defaultHeaders = [];
    
    /**
     * Whether to use cookies
     *
     * @var bool
     */
    protected $useCookies = false;
    
    /**
     * @inheritDoc
     */
    public function setUseCookies(bool $use = true)
    {
        $this->useCookies = $use;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setDefaultHeaders(array $headers)
    {
        $this->defaultHeaders = $headers;
        return $this;
    }
    
    /**
     * Get options for GuzzleHttp\Client
     * 
     * @return array
     */
    public function getGuzzleOptionsArray(): array
    {
        return [
            'cookies' => $this->useCookies,
            'headers' => $this->defaultHeaders
        ];
    }

    /**
     * @inheritDoc
     */
    public function getClient(): CommunicationClientInterface
    {
        return new GuzzleCommunicationClient($this);
    }

}
