<?php

namespace InSegment\ApiCore\Services\DiffSlice;

use InSegment\ApiCore\Services\SliceMerger\MergeManager;

class ImportClass
{
    
    /**
     * DiffSlice instance
     *
     * @var \InSegment\ApiCore\Services\DiffSlice\DiffSlice 
     */
    protected $diffSlice;
    
    /**
     * Reserve of supplementary keys
     *
     * @var \InSegment\ApiCore\Models\UUIDReserve
     */
    protected $uuidReserve;
    
    /**
     * Query for marking UUID's as used
     *
     * @var \InSegment\ApiCore\Services\BufferedBuilder
     */
    protected $uuidLogQuery;
    
    /**
     * @var string
     */
    protected $insertTable;
    
    /**
     * @var string
     */
    protected $updateTable;
    
    /**
     * @var string
     */
    protected $changesTable;
    
    /**
     * An example of model of the class
     *
     * @var \Illuminate\Database\Eloquent\Model
     */
    protected $example;
    
    /**
     * @var string|null
     */
    protected $keyName;
    
    /**
     * @var string
     */
    protected $tableName;
    
    /**
     * Constructor
     * 
     * @param \InSegment\ApiCore\Services\DiffSlice\DiffSlice $diffSlice
     * @param string $className
     */
    public function __construct(DiffSlice $diffSlice, string $className)
    {
        $this->diffSlice = $diffSlice;
        $this->uuidReserve = $diffSlice->getUuidReserve();
        $this->uuidLogQuery = $diffSlice->getUuidLogQuery();
        
        $this->example = new $className;
        $this->keyName = $this->example->getKeyName();
        $this->tableName = $this->example->getTable();
        
        $tempTables = $diffSlice->getTempTables($this->tableName);
        $this->insertTable = $tempTables[MergeManager::TEMP_TABLE_TYPE_INSERT];
        $this->updateTable = $tempTables[MergeManager::TEMP_TABLE_TYPE_UPDATE];
        $this->changesTable = $tempTables[MergeManager::TEMP_TABLE_TYPE_CHANGES];
    }
    
    /**
     * Add diff row of the class to the DiffSlice and return a key of the row (if any)
     * 
     * @param array $attributes
     * @return mixed
     */
    public function add(array $attributes)
    {
        $instance = $this->example->newInstance($attributes);
        $key = $instance->getKey();
        
        if ($this->keyName && $key !== null) {
            $instance->setTable($this->updateTable);
            if ($instance->save()) {
                $this->diffSlice->incrementWrittenCount($this->tableName);
            }
            
            $changes = [];
            foreach ($instance->getAttributes() as $attribute => $value) {
                $changes[$attribute] = $attribute === $this->keyName ? $value : 1;
            }
            
            $changesInstance = $this->example->newInstance();
            $changesInstance->setRawAttributes($changes);
            $changesInstance->setTable($this->changesTable);
            $changesInstance->save();
        } else if ($this->example->_incrementing) {
            $key = $this->uuidReserve->nextId($this->tableName);
            $instance->setAttribute($this->keyName, $key);
            $instance->setTable($this->insertTable);
            
            if ($instance->save()) {
                $this->uuidLogQuery->insertUpdate(['uuid' => $key, 'used' => true]);
                $this->diffSlice->incrementNewCount($this->tableName);
                $this->diffSlice->incrementWrittenCount($this->tableName);
            } else {
                $key = null;
            }
        } else {
            $instance->setTable($this->insertTable);
            
            if ($instance->save()) {
                $this->diffSlice->incrementNewCount($this->tableName);
                $this->diffSlice->incrementWrittenCount($this->tableName);
            }
        }
        
        return $key;
    }
    
}
