<?php

namespace InSegment\ApiCore\Services;

use Illuminate\Support\Arr;
use InSegment\ApiCore\Exceptions\ApiTransactorException;

class ExceptionDebug
{
    
    /**
     * Add exception debug information into response
     * 
     * @param array $response
     * @param \Throwable $exception
     * @param string $debug
     * @return null
     */
    public static function makeDebug(&$response, $exception, $debug = "debug")
    {
        // If the app is in debug mode
        if (config('api_core.exception_debug')) {
            $response[$debug][CODE] = $exception->getCode();
            $response[$debug][MSG] = $exception->getMessage();
            $response[$debug][FILE] = $exception->getFile();
            $response[$debug][LINE] = $exception->getLine();

            // special for Transactor
            if ($exception instanceof ApiTransactorException) {
                $response[$debug][DATA] = $exception->getData();
            }

            // for SQL Exceptions
            if ($exception instanceof \PDOException) {
                $response[$debug][SQL] = $exception->getSql(); // исходный sql запрос
                $response[$debug]["bindings"] = $exception->getBindings(); // параметры запроса
            }

            $response[$debug]["exception"] = get_class($exception);

            $response["debug"]["trace"] = array_map(function ($trace) {
                return Arr::only($trace, ["file", "line", "function", "class"]);
            }, $exception->getTrace());
        }
    }

}
