<?php

namespace InSegment\ApiCore\Services;

final class MicroEvent
{
    /**
     * Are eloquent events replaced
     *
     * @var bool 
     */
    private static $eloquentReplaced;
    
    /**
     * The event map.
     *
     * Allows for object-based events.
     *
     * @var array
     */
    protected static $events = [];

    /**
     * Tells if the event is set in the event map.
     * 
     * @param string $class
     * @param string $event
     * @return bool
     */
    public static function isEventSet($class, $event)
    {
        return isset(self::$events[$class][$event]);
    }

    /**
     * Register an event.
     * Will overwrite an existing event with the same name.
     *
     * @param string $class
     * @param string $event
     * @param callable $callback
     * @return void
     */
    public static function registerEvent($class, $event, callable $callback)
    {
        self::$events[$class][$event][] = $callback;
    }

    /**
     * Unregister an event.
     *
     * @param string $class
     * @param string $event
     * @return void
     */
    public static function unregisterEvent($class, $event)
    {
        unset(self::$events[$class][$event]);
    }

    /**
     * Fire the given event.
     *
     * @param string $class
     * @param string $event
     * @param array $args Array of arguments for callbacks.
     * @return bool
     */
    public static function fireEvent($class, $event, ...$args)
    {
        if (!isset(self::$events[$class][$event])) {
            return true;
        }

        foreach (self::$events[$class][$event] as $callback) {
            if ($callback(...$args) === false) {
                return false;
            }
        }

        return true;
    }

    /**
     * Are eloquent events replaced
     * 
     * @return bool
     */
    public static function replacesEloquentEvents()
    {
        if (!isset(self::$eloquentReplaced)) {
            self::$eloquentReplaced = !config('api_core.event_dispatch');
        }
        
        return self::$eloquentReplaced;
    }
}
