<?php

namespace InSegment\ApiCore\Services\SliceMerger;

class MergeOptions
{
    // TODO: OptionsBuilder with validation
    // TODO: Automatic validation of tempTables array for manually-specified order
    
    /**
     * Enumeration of temporary tables
     * 
     * @var array [
     *     string $tableName => [
     *         string $type => string $tempTableOfType,
     *         ...
     *     ],
     *     ...
     * ]
     */
    public $tempTables;
    
    /**
     * Tables to the keys which are mentioned in some UUID'able tables and thus may have updated key
     * 
     * @var array [
     *     string $tableName => string|string[] $keys,
     *     ...
     * ]
     */
    public $uuidableMentions;
    
    /**
     * @var string[]
     */
    public $deletionEnabledTables = [];
    
    /**
     * The class of the Model for table which contains map of UUID to the new identifiers
     * 
     * @var string
     */
    public $autoKeyRemapClass;
    
    /**
     * The class of the Model for matching the new identifiers in order
     *
     * @var string
     */
    public $generationsMatchClass;
    
    /**
     * @var string|null
     */
    public $uuidDeletesModelClass = \InSegment\ApiCore\Models\UUIDDeletion::class;
    
    /**
     * This class of the Model for table that lists records identifiers to be deleted from real tables
     * 
     * @var string|null
     */
    public $realDeletesModelClass;
    
    /**
     * This class of the Model for table with transacted records identifiers logged for use in post-processing
     *
     * @var string|null
     */
    public $logsModelClass;
    
}
