<?php

namespace InSegment\ApiCore\Traits;

use InSegment\ApiCore\Services\MicroEvent;

/**
 * To be used with \Illuminate\Database\Eloquent\Model
 * 
 * Replace eloquent events (globally dispatched) with local MicroEvents (visible only by direct subscribers)
 */
trait EventsReplace
{
    /**
     * Register a model event with the dispatcher.
     *
     * @param  string  $event
     * @param  \Illuminate\Events\QueuedClosure|\Closure|string  $callback
     * @return void
     */
    protected static function registerModelEvent($event, $callback)
    {
        if (MicroEvent::replacesEloquentEvents() && $callback instanceof \Closure) {
            MicroEvent::registerEvent(static::class, $event, $callback);
        
            return;
        }
        
        return parent::registerModelEvent($event, $callback);
    }

    /**
     * Fire the given event for the model.
     *
     * @param  string  $event
     * @param  bool  $halt
     * @return mixed
     */
    protected function fireModelEvent($event, $halt = true)
    {
        if (MicroEvent::replacesEloquentEvents() && MicroEvent::isEventSet(static::class, $event)) {
            MicroEvent::fireEvent(static::class, $event, $this);
        
            return;
        }
        
        return parent::fireModelEvent($event, $halt);
    }
}