<?php

namespace InSegment\ApiCore\Traits;

use InSegment\ApiCore\Services\Logger;

trait Loggable
{

    /**
     * @var Logger
     */
    protected $log;

    /**
     * 
     * @param Logger $logger
     * @return \self
     */
    public function setLogger(Logger $logger): self
    {
        $this->log = $logger;

        return $this;
    }
    
    /**
     * @return Logger
     */
    public function getLogger()
    {
        return $this->log;
    }

    public function closeLog()
    {
        $this->log->close();
    }

    /**
     * 
     * @param string $tag
     * @param array|string $data
     */
    public function pushLog(string $tag, $data): self
    {
        $this->log->push($tag, $data);

        return $this;
    }

    /**
     * 
     * @param string $tag
     * @param array|string $data
     */
    public function pushLogString(string $tag, $data): self
    {
        $this->log->pushString($tag, $data);

        return $this;
    }
}
