<?php

namespace InSegment\ApiCore\Traits;

trait SliceManagementTrait
{
    /**
     * Get slice operation UID
     * 
     * @return string
     */
    public abstract function getUID(): string;
    
    /**
     * Get count of records was written for table
     * 
     * @param string $table
     * @return int
     */
    public abstract function getWrittenCount(string $table): int;
    
    /**
     * Get count of records was inserted into table
     * 
     * @param string $table
     * @return int
     */
    public abstract function getNewCount(string $table): int;
    
}
