<?php

namespace InSegment\ApiCore\Traits;

use Illuminate\Support\Facades\DB;

trait SliceSchemaTrait
{
    
    /**
     * Schema name
     *
     * @var string
     */
    private $schema;
    
    /**
     * Get schema name for transaction tables
     * 
     * @return string
     */
    public function getSchema(): string
    {
        return $this->schema ?? config('api_core.transaction_schema') ?: DB::getDatabaseName();
    }
    
    /**
     * Set schema name for transaction tables
     * 
     * @param string $schemaName
     */
    public function setSchema(string $schemaName)
    {
        $this->schema = $schemaName;
    }

}
