<?php

namespace InSegment\ApiCore\Tests;

use InSegment\ApiCore\MappingTypes\Relation;
use InSegment\ApiCore\Middleware\ChooseVersion;
use InSegment\ApiCore\Facades\DTODefs;

class BuildsDictionariesTest
{
    const CLASS_TO_TEST = 'App\Company';
    const ONE_ATTRIBUTE_OF_CLASS_TO_TEST = 'campaign_id';
    const ANOTHER_ATTRIBUTE_OF_CLASS_TO_TEST = 'company_id';
    const REMAP_ONE_ATTRIBUTE_TO = 'foo';
    const REMAP_ANOTHER_ATTRIBUTE_TO = 'bar';
    
    public function runTests()
    {
        $this->testCompositeKeyWithRemap(false);
        $this->testCompositeKeyWithoutRemap(false);
        $this->testManyCompositeKeysWithRemap(false);
        $this->testManyCompositeKeysWithoutRemap(false);
        $this->testPlainKey(false);
        $this->testManyPlainKeys(false);
        $this->testCompositeKeyWithRemap(true);
        $this->testCompositeKeyWithoutRemap(true);
        $this->testManyCompositeKeysWithRemap(true);
        $this->testManyCompositeKeysWithoutRemap(true);
        $this->testPlainKey(true);
        $this->testManyPlainKeys(true);
    }
    
    public function testCompositeKeyWithoutRemap(bool $index) {
        ChooseVersion::chooseVersion();
        $dtoDefs = DTODefs::instance();
        $mapping = [
            "type" => "many",
            "class" => addslashes(self::CLASS_TO_TEST),
            "relation" => "companies",
            "key" => [self::ONE_ATTRIBUTE_OF_CLASS_TO_TEST, self::ANOTHER_ATTRIBUTE_OF_CLASS_TO_TEST]
        ];
        $class = self::CLASS_TO_TEST;
        $data = $class::where('id', '<', 2000)->orderByRaw('RAND()')->first()->getAttributes();
        $eki = Relation::getExtKeysInfo($dtoDefs, $mapping, $data, ['index' => $index]);
        echo "testCompositeKeyWithoutRemap:\n";
        var_dump($eki);
        sleep(2);
        echo "\n";
    }

    public function testCompositeKeyWithRemap(bool $index) {
        ChooseVersion::chooseVersion();
        $dtoDefs = DTODefs::instance();
        $mapping = [
            "type" => "many",
            "class" => addslashes(self::CLASS_TO_TEST),
            "relation" => "companies",
            "key" => [self::REMAP_ONE_ATTRIBUTE_TO => self::ONE_ATTRIBUTE_OF_CLASS_TO_TEST, self::REMAP_ANOTHER_ATTRIBUTE_TO => self::ANOTHER_ATTRIBUTE_OF_CLASS_TO_TEST]
        ];
        $class = self::CLASS_TO_TEST;
        $data = $class::where('id', '<', 2000)->orderByRaw('RAND()')->first()->getAttributes();
        $data[self::REMAP_ONE_ATTRIBUTE_TO] = $data[self::ONE_ATTRIBUTE_OF_CLASS_TO_TEST];
        $data[self::REMAP_ANOTHER_ATTRIBUTE_TO] = $data[self::ANOTHER_ATTRIBUTE_OF_CLASS_TO_TEST];
        unset($data[self::ONE_ATTRIBUTE_OF_CLASS_TO_TEST], $data[self::ANOTHER_ATTRIBUTE_OF_CLASS_TO_TEST]);
        $eki = Relation::getExtKeysInfo($dtoDefs, $mapping, $data, ['index' => $index]);
        echo "testCompositeKeyWithRemap:\n";
        var_dump($eki);
        sleep(2);
        echo "\n";
    }

    public function testManyCompositeKeysWithoutRemap(bool $index) {
        ChooseVersion::chooseVersion();
        $dtoDefs = DTODefs::instance();
        $mapping = [
            "type" => "many",
            "class" => addslashes(self::CLASS_TO_TEST),
            "relation" => "companies",
            "key" => [self::ONE_ATTRIBUTE_OF_CLASS_TO_TEST, self::ANOTHER_ATTRIBUTE_OF_CLASS_TO_TEST]
        ];
        $class = self::CLASS_TO_TEST;
        $data = $class::where('id', '<', 2000)->orderByRaw('RAND()')->take(2)->get()->reverse()->toArray();
        $eki = Relation::getExtKeysInfo($dtoDefs, $mapping, $data, ['multiple' => true, 'index' => $index]);
        echo "testManyCompositeKeysWithoutRemap:\n";
        var_dump($eki);
        sleep(2);
        echo "\n";
    }

    public function testManyCompositeKeysWithRemap(bool $index) {
        ChooseVersion::chooseVersion();
        $dtoDefs = DTODefs::instance();
        $mapping = [
            "type" => "many",
            "class" => addslashes(self::CLASS_TO_TEST),
            "relation" => "companies",
            "key" => [self::REMAP_ONE_ATTRIBUTE_TO => self::ONE_ATTRIBUTE_OF_CLASS_TO_TEST, self::REMAP_ANOTHER_ATTRIBUTE_TO => self::ANOTHER_ATTRIBUTE_OF_CLASS_TO_TEST]
        ];
        $class = self::CLASS_TO_TEST;
        $data = $class::where('id', '<', 2000)->orderByRaw('RAND()')->take(2)->get()->reverse()->toArray();
        foreach ($data as &$company) {
            $company[self::REMAP_ONE_ATTRIBUTE_TO] = $company[self::ONE_ATTRIBUTE_OF_CLASS_TO_TEST];
            $company[self::REMAP_ANOTHER_ATTRIBUTE_TO] = $company[self::ANOTHER_ATTRIBUTE_OF_CLASS_TO_TEST];
            unset($company[self::ONE_ATTRIBUTE_OF_CLASS_TO_TEST], $company[self::ANOTHER_ATTRIBUTE_OF_CLASS_TO_TEST]);
        }
        $eki = Relation::getExtKeysInfo($dtoDefs, $mapping, $data, ['multiple' => true, 'index' => $index]);
        echo "testManyCompositeKeysWithRemap:\n";
        var_dump($eki);
        sleep(2);
        echo "\n";
    }

    public function testPlainKey(bool $index) {
        ChooseVersion::chooseVersion();
        $dtoDefs = DTODefs::instance();
        $mapping = [
            "type" => "many",
            "class" => addslashes(self::CLASS_TO_TEST),
            "relation" => "companies",
            "key" => self::ANOTHER_ATTRIBUTE_OF_CLASS_TO_TEST
        ];
        $class = self::CLASS_TO_TEST;
        $data = $class::where('id', '<', 2000)->orderByRaw('RAND()')->first()->getAttributes();
        $eki = Relation::getExtKeysInfo($dtoDefs, $mapping, $data, ['index' => $index]);
        echo "testPlainKey:\n";
        var_dump($eki);
        sleep(2);
        echo "\n";
    }

    public function testManyPlainKeys(bool $index) {
        ChooseVersion::chooseVersion();
        $dtoDefs = DTODefs::instance();
        $mapping = [
            "type" => "many",
            "class" => addslashes(self::CLASS_TO_TEST),
            "relation" => "companies",
            "key" => self::ANOTHER_ATTRIBUTE_OF_CLASS_TO_TEST
        ];
        $class = self::CLASS_TO_TEST;
        $data = $class::where('id', '<', 2000)->orderByRaw('RAND()')->take(2)->get()->reverse()->toArray();
        $eki = Relation::getExtKeysInfo($dtoDefs, $mapping, $data, ['multiple' => true, 'index' => $index]);
        echo "testManyPlainKeys:\n";
        var_dump($eki);
        sleep(2);
        echo "\n";
    }
    
}