<?php

namespace InSegment\ApiCore\Tests;

use InSegment\ApiCore\Interfaces\SADConsumer;
use InSegment\ApiCore\Models\SourceAttributeDownstream;

class SourceAttributeDownstreamTest
{
    const CLASS_TO_TEST = \App\Industry::class;
    const TEST_ATTRIBUTES = ['id', 'name', 'subIndustries'];
    const TEST_RECURSIVE_RELATION_ATTRIBUTE = 'subIndustries';
    const TEST_MODIFICATION_OF_ATTRIBUTE = 'name';
    const TEST_RULES = [
        self::CLASS_TO_TEST => self::TEST_ATTRIBUTES,
    ];
    
    public function getDictionaryOfSomething()
    {
        $class = self::CLASS_TO_TEST;
        return $class::dictionary()->all();
    }
    
    public function iterationTest()
    {
        $source = $this->getDictionaryOfSomething();
        $sad = new SourceAttributeDownstream(self::TEST_RULES);
        
        $consumer = new class($sad) implements SADConsumer {
            public $result = [];
            private $sad;
            private $currentModel;
            
            public function __construct(SourceAttributeDownstream $sad)
            {
                $this->sad = $sad;
            }
            
            public function acceptAttribute($attribute)
            {
                if ($attribute === SourceAttributeDownstreamTest::TEST_RECURSIVE_RELATION_ATTRIBUTE) {
                    if ($this->currentModel->relationLoaded(SourceAttributeDownstreamTest::TEST_RECURSIVE_RELATION_ATTRIBUTE)) {
                        $source = $this->currentModel->getAttribute(SourceAttributeDownstreamTest::TEST_RECURSIVE_RELATION_ATTRIBUTE)->all();
                        $this->sad->newSource($source, SourceAttributeDownstreamTest::CLASS_TO_TEST);
                    } else {
                        $this->sad->addDownStream($this->currentModel->getAttribute(SourceAttributeDownstreamTest::TEST_MODIFICATION_OF_ATTRIBUTE).'Test');
                    }
                } else if (($value = $this->currentModel->getAttribute($attribute))) {
                    $this->currentModel->setAttribute($attribute, $value.'Processed');
                }
            }

            public function acceptDownstream($downstream)
            {
                $this->currentModel->setAttribute($downstream, $downstream);
            }

            public function acceptModel($model)
            {
                $this->result[] = 'accept: ' . json_encode($model);
                $this->currentModel = $model;
            }
            
            public function saveModel($model)
            {
                $this->result[] = 'save: ' . json_encode($model);
                $this->currentModel->setAttribute('saved', 'true');
            }
        };
        
        $sad->iterateArrayOfModels($consumer, $source, self::CLASS_TO_TEST);
        // throw new \Exception;
        dd(json_encode($consumer->result, JSON_PRETTY_PRINT));
    }
}
